<xsl:stylesheet 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:ns2="http://www.w3.org/2000/09/xmldsig#" 
xmlns:akczc="https://puesc.gov.pl/ZEFIR2/xsd/v1_0/AKC_ZC.xsd" 
xmlns:ns1="https://puesc.gov.pl/ZEFIR2/xsd/v1_0/AKC_ZC.xsd" 
xmlns:tp13="https://puesc.gov.pl/ZEFIR2/xsd/v13_0/Types.xsd" 
xmlns:tr13="https://puesc.gov.pl/ZEFIR2/xsd/v13_0/Trader.xsd" 
xmlns:tp="https://puesc.gov.pl/ZEFIR2/xsd/v13_0/Types.xsd" 
xmlns:tr="https://puesc.gov.pl/ZEFIR2/xsd/v13_0/Trader.xsd" 
version="1.0">
	<xsl:decimal-format NaN="" decimal-separator="." grouping-separator=" "/>
	<xsl:output encoding="iso-8859-1" method="html"/>
	<xsl:template match="/">
		<xsl:apply-templates select="*"/>
	</xsl:template>
	<!-- POCZATEK ALL -->
	<!-- STYL ARKUSZA -->
	<xsl:template match="*" mode="styl1">
		<style type="text/css">body {margin:0;font-family:Verdana,Helvetica,sans-serif;font-size:10px;text-align:justify;}</style>
		<style type="text/css">*{font-family:Verdana,Helvetica,sans-serif;padding:3px;color:black;}</style>
		<style type="text/css">a{color:#3366FF;font-weight:bold;}</style>
		<style type="text/css">h3{padding:3px;cursor:help;}</style>
		<style type="text/css">h4,h5,.copyr{text-align:center;}</style>
		<style type="text/css">caption{font-weight:bold;}</style>
		<style type="text/css">table,div,td{font-size:8pt;border-color:black;}</style>
		<style type="text/css">table{border-top:1 solid;border-bottom:2 solid;border-left:1 solid;border-right:1 solid;}</style>
		<style type="text/css">th,td{border-top:1 solid;border-bottom:1 solid;border-left:1 solid;border-right:1 solid;}</style>
		<style type="text/css">#cont{display:none}</style>
		<style type="text/css">.copyr{background:#B1D8FF;font-weight:bold;}</style>
		<style type="text/css">.nag1 {font-size: 20px; font-weight: bold;}</style>
		<style type="text/css">.nag2{font-size: 20px}</style>
		<style type="text/css">.cz10 {font-size: 10px}</style>
		<style type="text/css">.cz12 {font-size: 12px}</style>
		<style type="text/css">.cz18 {font-size: 18px}</style>
		<style type="text/css">.cz16 {font-size: 16px}</style>
		<style type="text/css">.cz14 {font-size: 14px}</style>
	</xsl:template>
	<!-- SZABLON STOPKI -->
	<xsl:template match="*" mode="stopka"> AKC-ZC/AKC-ZCn </xsl:template>
	<xsl:template match="*">
		<!-- ZASTOSOWANIE STYLU -->
		<xsl:apply-templates mode="styl1" select="*"/>
		<!-- DEKLARACJE AKCYZOWE -->
		<xsl:apply-templates mode="dekl_AKCST" select="."/>
	</xsl:template>
	<!-- SZABLON DOT. DEKLARACJI AKCYZOWYCH -->
	<xsl:template match="*" mode="dekl_AKCST">
		<xsl:for-each select="ns1:Header|  ns1:* | akczc:*">
			<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
			<xsl:apply-templates mode="Ident" select="."/>
			<!-- SZABLON DLA RODZAJU DEKLARACJI -->
			<xsl:apply-templates mode="rodz_dekl" select="."/>
			<!-- SZABLON DOT.  OKRESU ROK MIESIAC -->
			<xsl:apply-templates mode="rok_mc" select="."/>
			<!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI -->
			<xsl:apply-templates mode="PodstawaPrawna" select="."/>
			<!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI -->
			<xsl:apply-templates mode="MiejsceDekl" select="."/>
			<!-- SZABLON DOT. DANYCH PODATNIKA -->
			<xsl:apply-templates mode="DanePodatnika" select="."/>
			<!-- SZABLON DOT. ADRESU PODATNIKA -->
			<xsl:apply-templates mode="Adres" select="."/>
			<!-- SZABLON DOT. WYROBOW -->
			<xsl:apply-templates mode="Wyroby" select="."/>
			<!-- SZABLON DOT. KWOTY PODATKU -->
			<xsl:apply-templates mode="KwotaPodatku" select="."/>
			<!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ -->
			<xsl:apply-templates mode="OswPodatnika" select="."/>
			<!-- SZABLON DOT. ADNOTACJI-->
			<xsl:apply-templates mode="Adnotacje" select="."/>
			<!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA-->
			<xsl:apply-templates mode="ObjasnieniaAkc" select="."/>
		</xsl:for-each>
	</xsl:template>
	<!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA-->
	<xsl:template match="*" mode="Ident">
		<table border="1" width="955">
			<tr align="left" valign="top">
				<td align="left" colspan="2" height="45" valign="middle" width="586">
					<span class="cz12">
						<xsl:choose>
							<xsl:when test="string-length(@identifier)='10'">
								<b>1. Identyfikator podatkowy NIP/<s>numer PESEL</s>
								</b>
								<sup>(niepotrzebne skreślić)</sup>
								<b> podatnika</b>
								<sup>1)</sup>
							</xsl:when>
							<xsl:otherwise>
								<b>1. <s>Identyfikator podatkowy NIP</s>/numer PESEL <sup>(niepotrzebne skreślić)</sup> podatnika<sup>1)</sup>
								</b>
							</xsl:otherwise>
						</xsl:choose>
					</span>
				</td>
				<td align="center" colspan="2" valign="middle" width="353">
					<span class="nag2">
						<b>
							<xsl:value-of select="@identifier"/>
						</b>
					</span>
				</td>
			</tr>
			<tr align="left" colspan="1" valign="top">
				<td align="left" height="45" valign="top" width="353"/>
				<td align="left" bgcolor="#CCCCCC" colspan="2" height="45" valign="top">
					<b>2. Nr dokumentu</b>
					<br/>
					<span class="cz16">
						<b>
							<xsl:value-of select="@selfRef"/>
						</b>
					</span>
				</td>
				<td align="left" bgcolor="#CCCCCC" colspan="1" height="45" valign="top">
					<b>3. Status</b>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON DOT.  RODZAJU DEKLARACJI -->
	<xsl:template match="*" mode="rodz_dekl">
		<xsl:if test="ns1:* | akczc:*">
			<table border="1" width="956">
				<tr>
					<td colspan="3" height="40">
						<xsl:choose>
							<xsl:when test=".//@formKind='AKC-ZC'">
								<span class="nag1">
									<b>AKC-ZC/</b>
									<b>
										<s>AKC-ZCn</s>
									</b>
								</span>
								<sup>(niepotrzebne skreślić),<b>2)</b>
								</sup>
							</xsl:when>
							<xsl:when test=".//@formKind='AKC-ZCn'">
								<span class="nag1">
									<s>AKC-ZC/</s>
									<b>
										<b>AKC-ZCn</b>
									</b>
								</span>
								<sup>(niepotrzebne skreślić),<b>2)</b>
								</sup>
							</xsl:when>
							<xsl:otherwise>
								<span class="nag1">AKC-ZC/AKC-ZCn </span>
								<sup>(niepotrzebne skreślić),<b>2)</b>
								</sup>
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
				<tr>
					<!-- <td height="61" width="154"/> -->
					<td width="537">
						<div align="left">
							<span class="nag1">DEKLARACJA W SPRAWIE PODATKU AKCYZOWEGO OD ZESTAWÓW CZĘŚCI DO URZĄDZEŃ DO WAPORYZACJI</span>
							<br/>
							<span class="nag2">za</span>
						</div>
					</td>
					<!-- <td width="243"/>-->
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT.  OKRESU ROK MIESIAC -->
	<xsl:template match="*" mode="rok_mc">
		<xsl:if test="ns1:* | akczc:*">
			<table>
				<tr>
					<td height="49" width="135">
						<b>4. Miesiąc </b>
						<br/>
						<div align="center" class="cz18">
							<xsl:value-of select="substring(@period,6,7)"/>
						</div>
					</td>
					<td align="left" valign="top" width="135">
						<b>5. Rok </b>
						<br/>
						<div align="center" class="cz18">
							<xsl:value-of select="substring(@period,1,4)"/>
						</div>
					</td>
					<!--<td align="left" valign="top" width="131">  </td> <td width="206"/> -->
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI -->
	<xsl:template match="*" mode="PodstawaPrawna">
		<xsl:if test="ns1:* | akczc:*">
			<table border="1" width="955">
				<tr bgcolor="#CCCCCC">
					<td align="left" valign="top" width="115">Podstawa prawna: </td>
					<td align="left" valign="top" width="824">Art. 24ba ustawy z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2025 r. poz. 126, z późn. zm.).</td>
				</tr>
				<tr bgcolor="#CCCCCC">
					<td align="left" valign="top">Termin składania:</td>
					<td align="left" valign="top">Do 25. dnia miesiąca następującego po miesiącu, w którym powstał obowiązek podatkowy. </td>
				</tr>
				<tr bgcolor="#CCCCCC">
					<td align="left" valign="top">Miejsce składania: </td>
					<td align="left" valign="top">Urząd skarbowy, przy pomocy którego wykonuje swoje zadania naczelnik urzędu skarbowego właściwy ze względu na miejsce wykonywania czynności lub wystąpienia stanów faktycznych, podlegających opodatkowaniu podatkiem akcyzowym; jeżeli czynności podlegające opodatkowaniu są wykonywane lub stany faktyczne podlegające opodatkowaniu występują na obszarze właściwości miejscowej dwóch lub więcej naczelników urzędów skarbowych – zgodnie z art. 14 ust. 4–4f ustawy z dnia 6 grudnia 2008 r. o podatku akcyzowym; jeżeli właściwym organem podatkowym jest Naczelnik Trzeciego Urzędu Skarbowego Warszawa-Śródmieście w Warszawie, to miejscem składania jest Trzeci Urząd Skarbowy Warszawa-Śródmieście w Warszawie. </td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI -->
	<xsl:template match="*" mode="MiejsceDekl">
		<xsl:if test="ns1:* | akczc:*">
			<table border="1" width="955">
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td colspan="4">
						<span class="nag1">A. WŁAŚCIWY ORGAN I CEL SKŁADANIA DEKLARACJI</span>
					</td>
				</tr>
				<tr align="left" valign="top">
					<td bgcolor="#CCCCCC" rowspan="4" width="46"/>
					<td colspan="4">
						<b>6.Naczelnik urzędu skarbowego</b>
						<br/>
						<span class="cz18">
							<xsl:value-of select="@taxOfficeName"/>
						</span>
					</td>
				</tr>
				<tr>
					<td class="style3">
						<b>7. Cel złożenia formularza</b>(zaznaczyć właściwy kwadrat):  <br/>
						<br/>
						<p>
							<xsl:choose>
								<xsl:when test="//@submissionAim='Deklaracja'"> ☑ 1. złożenie deklaracji ☐  2. korekta deklaracji<sup style="cz9">3)</sup>
								</xsl:when>
								<xsl:otherwise>
									<b/>
								</xsl:otherwise>
							</xsl:choose>
							<xsl:choose>
								<xsl:when test="//@submissionAim='Korekta'"> ☐ 1. złożenie deklaracji ☑  2. korekta deklaracji<sup style="cz9">3)</sup>
								</xsl:when>
								<xsl:otherwise>
									<b/>
								</xsl:otherwise>
							</xsl:choose>
						</p>
					</td>
				</tr>
				<td colspan="4">
					<b>Uzasadnienie: </b>
					<span class="cz18">
						<xsl:value-of select="@justification"/>
					</span>
				</td>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT. DANYCH PODATNIKA -->
	<xsl:template match="*" mode="DanePodatnika">
		<xsl:if test="ns1:* | akczc:*">
			<table border="1" width="955">
				<tr bgcolor="#CCCCCC">
					<td colspan="4">
						<span class="nag1">B. DANE PODATNIKA</span>
					</td>
				</tr>
				<tr bgcolor="#CCCCCC">
					<td colspan="4">
						<span class="nag2">B.1. DANE IDENTYFIKACYJNE</span>
					</td>
				</tr>
				<tr>
					<td bgcolor="#CCCCCC" rowspan="3" width="40"/>
					<td align="left" colspan="3" height="27" valign="top">
						<b>8. Rodzaj podatnika</b>(zaznaczyć właściwy kwadrat): </td>
				</tr>
				<tr>
					<xsl:if test=".//ns1:Trader/@typeOfTaxpayer='N'">
						<td align="left" valign="top" width="422">1. podatnik niebędący osobą fizyczną<br/>
							<span class="cz18"> ☑ </span>
						</td>
						<td align="left" valign="top" width="471">2. osoba fizyczna<br/>
							<span class="cz18"> ☐ </span>
						</td>
					</xsl:if>
					<xsl:if test=".//ns1:Trader/@typeOfTaxpayer='F'">
						<td align="left" valign="top" width="422">1. podatnik niebędący osobą fizyczną<br/>
							<span class="cz18"> ☐ </span>
						</td>
						<td align="left" valign="top" width="471">2. osoba fizyczna<br/>
							<span class="cz18"> ☑ </span>
							<br/>
						</td>
					</xsl:if>
				</tr>
				<tr>
					<td align="left" colspan="3" valign="top">
						<b>9. Nazwa pełna<sup>4)</sup>/Nazwisko, pierwsze imię<sup>5)</sup>
						</b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="//@fullName"/>
						</span>
						<span class="cz18">
							<xsl:value-of select=".//tr:PrivatePerson/tr:BasicData/@surname"/>
						</span>
						<span class="cz18">
							<xsl:value-of select=".//tr:PrivatePerson/tr:BasicData/@firstName"/>
						</span>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT. ADRESU PODATNIKA -->
	<xsl:template match="*" mode="Adres">
		<xsl:if test="ns1:* | akczc:*">
			<table border="1" width="955">
				<tr bgcolor="#CCCCCC">
					<td colspan="6">
						<span class="nag2">B.2. ADRES SIEDZIBY<sup>4)</sup>/ ADRES ZAMIESZKANIA<sup>5)</sup>
						</span>
					</td>
				</tr>
				<tr align="left" valign="top">
					<td bgcolor="#CCCCCC" rowspan="3" width="40"/>
					<td width="269">
						<b>10. Kraj </b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select=".//@countryName"/>
						</span>
					</td>
					<td colspan="2">
						<b>11. Województwo</b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select=".//@provinceName"/>
						</span>
					</td>
					<td colspan="2">
						<b>12. Powiat</b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select=".//@districtName"/>
						</span>
					</td>
				</tr>
				<tr align="left" valign="top">
					<td>
						<b>13. Gmina </b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select=".//@communeName"/>
						</span>
					</td>
					<td colspan="2">
						<b>14. Ulica</b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select=".//@street"/>
						</span>
					</td>
					<td width="144">
						<b>15. Nr domu</b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select=".//@houseNumber"/>
						</span>
					</td>
					<td width="151">
						<b>16. Nr lokalu</b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select=".//@localNumber"/>
						</span>
					</td>
				</tr>
				<tr align="left" valign="top">
					<td colspan="4">
						<b>17. Miejscowość</b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select=".//@city"/>
						</span>
					</td>
					<td>
						<b>18. Kod pocztowy</b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select=".//@postalCode"/>
						</span>
					</td>
				</tr>
			</table>
			<table width="955">
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1">
							<xsl:apply-templates mode="stopka" select="../.."/>
						</span>
						<sub style="cz9">(1)</sub>
						<b style="nag1">/1</b>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT. KWOTY PODATKU -->
	<xsl:template match="ns1:Header | akczc:*" mode="KwotaPodatku">
		<table border="1" width="955">
			<tr>
				<td bgcolor="#CCCCCC" rowspan="5" width="40">
					<p/>
					<p/>
					<p/>
					<p/>
				</td>
				<td align="left" bgcolor="#CCCCCC" height="42" valign="top" width="610">
					<b>Zwolnienia</b>
				</td>
				<td align="left" colspan="2" valign="top" width="283">
					<b>41.</b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(//@exemption),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" height="42" valign="top" width="610">
					<b>Obniżenia</b>
				</td>
				<td align="left" colspan="2" valign="top" width="283">
					<b>42.</b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(//@reductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td align="left" bgcolor="#CCCCCC" height="46" valign="top">
					<b>Razem zwolnienia i obniżenia </b>
					<br/>
					<p>Suma kwot z poz. 41 i 42 nie może przekroczyć kwoty z poz. 40.</p>
				</td>
				<td align="left" colspan="2" valign="top">
					<b>43.</b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(//@totalExemptionOfReductions),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
			<tr>
				<td bgcolor="#CCCCCC">
					<b>Podatek akcyzowy do zapłaty <sup>6)</sup>
					</b>
					<br/>
					<p>Od kwoty wykazanej w poz. 40 należy odjąć kwotę z poz. 43.</p>
				</td>
				<td align="left" colspan="2" valign="top">
					<b>44.</b>
					<br/>
					<br/>
					<div align="right" class="cz18" valign="top">
						<xsl:value-of select="format-number(number(//@toPay),'# ##0')"/>
						<span align="right" class="cz9" valign="bottom">zł</span>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- SZABLON DOT. WYROBOW -->
	<xsl:template match="ns1:* | akczc:*" mode="Wyroby">
		<!-- ZNAK KONCA STRONY DO WYDRUKU -->
		<div style="page-break-before: always">
			<!-- <table width="955" border="1"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"><b><xsl:apply-templates select=".." mode = "stopka"/></b></span> </td> </tr> </table> -->
		</div>
		<table border="1" width="955">
			<!-- NAGLOWEK -->
			<tr align="left" bgcolor="#CCCCCC" valign="top">
				<td class="nag1" colspan="7">C. OBLICZENIE WYSOKOŚCI PODATKU AKCYZOWEGO OD ZESTAWÓW CZĘŚCI DO URZĄDZEŃ DO WAPORYZACJI</td>
			</tr>
			<!-- I-OPIS -->
			<tr align="center" bgcolor="#CCCCCC" valign="middle">
				<td width="20">Lp.</td>
				<td width="301">Nazwa wyrobu</td>
				<td width="101">
					<p align="center">Liczba wyrobów w sztukach<br/></p>
				</td>
				<td width="140">
					<p align="center">Stawka podatku<BR/>(w zł)</p>
				</td>
				<td width="133">
					<p align="center">Podatek akcyzowy<sup>6)</sup>
					</p>
				</td>
				<td width="143">
					<p align="center">Zwolnienie od podatku akcyzowego <br/>(zaznaczyć właściwy kwadrat) </p>
				</td>
				<!--<td width="127"> Kwota stanowiąca wartość podatkowych znaków akcyzy.</td> -->
			</tr>
			<!-- II-WIERSZ - OZNACZENIE -->
			<tr align="center" bgcolor="#CCCCCC" valign="middle">
				<td>
					<div align="center">
						<b>a.</b>
					</div>
				</td>
				<td>
					<div align="center">
						<b>b.</b>
					</div>
				</td>
				<td>
					<div align="center">
						<b>c.</b>
					</div>
				</td>
				<td>
					<div align="center">
						<b>d.</b>
					</div>
				</td>
				<td>
					<div align="center">
						<b>e.</b>
					</div>
				</td>
				<td>
					<div align="center">
						<b>f.</b>
					</div>
				</td>
				<!--<td> <div align="center"> <b>g.</b> </div> </td> -->
			</tr>
			<!-- III - WARTOSCI -->
			<xsl:for-each select=".//ns1:Item |.//akczc:Item">
				<tr align="left" valign="top">
					<td>
						<div align="right" class="cz18" valign="top">
							<xsl:value-of select="@id"/>
						</div>
					</td>
					<td>
						<div align="left" class="cz14" valign="top">
							<xsl:value-of select="@goodsName"/>
						</div>
					</td>
					<td>
						<div align="right" class="cz18" valign="top">
							<xsl:value-of select="@numberOfSetsOfPartsForVaporizationDevices"/>
						</div>
					</td>
					<td>
						<div align="right" class="cz18" valign="top">
							<xsl:value-of select="@taxRate"/>
						</div>
					</td>
					<td>
						<div align="right" class="cz18" valign="top">
							<xsl:value-of select="format-number(number(@amountOfTax),'# ##0')"/> zł <!--<div align="right" class="cz9" valign="bottom">zł</div> -->
						</div>
					</td>
					<td>
						<div align="right" class="cz14" valign="top">
							<xsl:if test="@exemptionFromExciseDuty='false'">tak ☐ / ☑ nie  </xsl:if>
							<xsl:if test="@exemptionFromExciseDuty='true'">tak ☑ / ☐ nie </xsl:if>
						</div>
					</td>
					<!--<td> <div align="right" class="cz18" valign="top"> <xsl:value-of select="@amountOfExciseStamps"/> </div> </td> -->
				</tr>
			</xsl:for-each>
			<!-- PODSUMOWANIE TABELKI -->
			<xsl:for-each select=".">
				<!-- <tr> <td>-</td> <td bgcolor="#CCCCCC"> <b>Sprzedaz na eksport </b> </td> <td bgcolor="#CCCCCC"> <div class="cz12" align="right" valign="top"><b><xsl:value-of select="./*/@export"/></b></div> </td> <td>-</td> <td>-</td> <td>-</td> <td>-</td> </tr> -->
				<tr>
					<td bgcolor="#CCCCCC"/>
					<td bgcolor="#CCCCCC">
						<div align="left" class="cz14" valign="top">
							<b>Razem</b>
						</div>
					</td>
					<td>
						<b>39.</b>
						<div align="right" class="cz14" valign="top">
							<b>
								<xsl:value-of select="./*/@totalNumberOfSetsOfPartsForVaporizationDevices"/>
							</b>
						</div>
					</td>
					<td bgcolor="#CCCCCC"/>
					<td>
						<b>40.</b>
						<div align="right" class="cz14" valign="top">
							<b>
								<xsl:value-of select="format-number(number(./*/@totalAmountOfTax),'# ##0')"/> zł <!-- <div align="right" class="cz9" valign="bottom">zł</div>  -->
							</b>
						</div>
					</td>
					<td bgcolor="#CCCCCC"/>
					<!--	<td> <b>23.</b> <div align="right" class="cz14" valign="top"> <b> <xsl:value-of select="format-number(number(./*/@totalAmountOfExciseStamps),'# ##0')"/> <xsl:value-of select="format-number(number(./*/@totalAmountOfReductions),'# ##0')"/>  </b> </div> </td> -->
				</tr>
			</xsl:for-each>
		</table>
	</xsl:template>
	<!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ -->
	<xsl:template match="*" mode="OswPodatnika">
		<xsl:if test="ns1:* | tp13:* | akczc:* | tp:*">
			<table border="1" height="210" width="955">
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td colspan="3">
						<b>
							<span class="nag1">D. PODPIS PODATNIKA LUB OSOBY REPREZENTUJĄCEJ PODATNIKA</span>
						</b>
					</td>
				</tr>
				<tr align="left" valign="top">
					<td bgcolor="#CCCCCC" rowspan="4" width="40"/>
					<td height="37" width="402">
						<b>45. Imię </b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="//@repFirstName"/>
						</span>
					</td>
					<td width="491">
						<b>46. Nazwisko </b>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="//@repSurname "/>
						</span>
					</td>
				</tr>
				<tr align="left" valign="top">
					<td colspan="2">
						<b>47. Podpis podatnika lub osoby reprezentującej podatnika </b>
						<span class="cz18">
							<br/>
						</span>
					</td>
				</tr>
				<tr align="left" valign="top">
					<td height="39">
						<xsl:choose>
							<xsl:when test="string-length(//@repIdentifier)= 11">
								<b>48. <s>Identyfikator podatkowy NIP</s>/numer PESEL</b>
								<sup>(niepotrzebne skreślić)</sup>
								<b> osoby składającej podpis</b>
								<sup>1)</sup>
							</xsl:when>
							<xsl:otherwise>
								<b>48. Identyfikator podatkowy NIP/<s>numer PESEL</s>
								</b>
								<sup>(niepotrzebne skreślić)</sup>
								<b> osoby składającej podpis</b>
								<sup>1)</sup>
							</xsl:otherwise>
						</xsl:choose>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="//@repIdentifier"/>
						</span>
					</td>
					<td>
						<b>49. Data wypełnienia deklaracji</b> (dzień – miesiąc – rok) <br/>
						<br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="substring(//@declarationDate,9,2)"/>
							<xsl:value-of select="substring(//@declarationDate,5,4)"/>
							<xsl:value-of select="substring(//@declarationDate,1,4)"/>
						</span>
					</td>
				</tr>
				<tr align="left" valign="top">
					<td colspan="3">
						<b>50. Numer telefonu i adres e-mail podatnika lub osoby reprezentującej podatnika</b> (pozycja nieobowiązkowa) <br/>
						<br/>
						<span class="cz18">
							<xsl:value-of select="ns1:Statement/tp13:representative/@phone"/>
						</span>
						<span class="cz18">
							<xsl:value-of select="ns1:Statement/tp13:representative/@email"/>
						</span>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT. ADNOTACJI-->
	<xsl:template match="*" mode="Adnotacje">
		<xsl:if test="ns1:* | akczc:*">
			<table border="1" height="167" width="955">
				<tr bgcolor="#CCCCCC">
					<td colspan="3" height="36">
						<span class="nag1">E. ADNOTACJE URZĘDU SKARBOWEGO<sup>7)</sup>
						</span>
						<!--<br/> W przypadku deklaracji złożonej w wersji elektronicznej wypełnienie pól: 32, 33 i 34 nie jest obowiązkowe.-->
					</td>
				</tr>
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td rowspan="2" width="40"/>
					<td colspan="2" height="72">
						<b>51. Uwagi urzędu skarbowego <br/>
							<br/>
							<br/>
							<br/>
							<br/>
							<br/>
							<br/>
						</b>
					</td>
				</tr>
				<tr align="left" bgcolor="#CCCCCC" valign="top">
					<td height="49" width="472">
						<b>52. Identyfikator przyjmującego formularz <br/>
							<br/>
							<br/>
						</b>
						<p/>
					</td>
					<td width="421">
						<b>53. Podpis przyjmującego formularz </b>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA-->
	<xsl:template match="*" mode="ObjasnieniaAkc">
		<xsl:if test="ns1:* | akczc:*">
			<table width="955">
				<tr>
					<td>
						<p align="center">
							<b>Objaśnienia</b>
						</p>
						<sup>1)</sup> Numer PESEL należy podać w przypadku osób fizycznych niebędących zarejestrowanymi podatnikami podatku od towarów i usług lub nieprowadzących działalności gospodarczej.<br/>
						<sup>2)</sup> Jeżeli deklaracja jest składana w związku z nabyciem wewnątrzwspólnotowym zestawów części do urządzeń do waporyzacji, należy przekreślić AKC-ZC; w pozostałych przypadkach należy przekreślić AKC-ZCn.<br/>
						<sup>3)</sup> Zgodnie z art. 81 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa (Dz. U. z 2025 r. poz. 111, z późn. zm.).  <br/>
						<sup>4)</sup> Dotyczy podatników niebędących osobami fizycznymi.<br/>
						<sup>5)</sup> Dotyczy podatników będących osobami fizycznymi.<br/>
						<sup>6)</sup> Kwoty podatków zaokrągla się do pełnych złotych w ten sposób, że końcówki kwot wynoszące mniej niż 50 groszy pomija się, a końcówki kwot wynoszące 50 i więcej groszy podwyższa się do pełnych złotych – zgodnie z art. 63 § 1 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa.<br/>
						<sup>7)</sup> Część E nie jest wypełniana w przypadku otrzymania przez urząd skarbowy deklaracji za pomocą środków komunikacji elektronicznej.<br/>
						<p align="center">
							<b>Pouczenia</b>
						</p> W przypadku niewpłacenia w obowiązującym terminie podatku z poz. 44 lub wpłacenia go w niepełnej wysokości niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz. U. z 2024 r. poz. 132, z późn. zm.). <p/> Za podanie nieprawdy lub zatajenie prawdy i przez to narażenie podatku na uszczuplenie grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym. </td>
				</tr>
				<tr align="right" valign="top">
					<td colspan="3">
						<span class="nag1">
							<xsl:apply-templates mode="stopka" select="../.."/>
						</span>
						<sub style="cz9">(1)</sub>
						<b style="nag1">/2</b>
					</td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	<!-- KONIEC support by PK editet 2025-08-08 -->
</xsl:stylesheet>